PROGRAM envoltorio_poeira

    !Definindo um módulo com constantes e variáveis globais utilizadas
    MODULE dados_globais
    
        IMPLICIT NONE
        SAVE
    
        !Declaração de constantes
        DOUBLE PRECISION, PARAMETER :: h = 6.626 * 10 ** (-22), c = 2.998 * 10 ** 14, k = 1.381 * 10 ** (-11), pi = 3.142
                                       !Respectivamente, a constante de Planck em microns^2 kg/s, a velocidade da luz no
                                       !vácuo em microns/s e a constante de Boltzmann dada em (microns^2 kg)/(s K) e um
                                       !valor aproximado para pi.
                        
        !Declaração de variáveis
        DOUBLE PRECISION :: banda1, banda2, Tef, Tpoeira, Re, Ri, R, a, n
                            !Respectivamente, 2 bandas observadas que darão
                            !um índice de cor, temperatura efetiva da estrela,
                            !temperatura da poeira, raios externo e interno
                            !da casca esférica de poeira, raio da estrela, raio
                            !dos grãos de poeira e densidade numérica de grãos.

    END MODULE dados_globais
    
    !Função que calcula a função de corpo negro para um dado comprimento de onda (comp_onda) e uma dada temperatura (T)
    DOUBLE PRECISION FUNCTION corponegro(comp_onda, T)
    
        USE dados_globais !Utilização do módulo definido anteriormente.
        IMPLICIT NONE !precisa disso aqui??
        SAVE !e disso??
    
        !Declaração de argumentos
        DOUBLE PRECISION, INTENT(IN) :: comp_onda, T
        
        !Declaração de variáveis internas
        DOUBLE PRECISION :: expoente, divisor
                            !Partes do cálculo da função,
                            !separadas por fins de clareza
                            !e organização do código.
        
        !Calculando a função de corpo negro
        expoente = (h * c / comp_onda * k * T) - 1
        divisor = comp_onda**5 * exp(expoente)
        
        corponegro = (2 * h * c**2) / divisor
    
    END FUNCTION corponegro

    !Função que relaciona a densidade numérica de grãos de poeira com outros parâmetros estelares e do envoltório e com algum índice de cor
    DOUBLE PRECISION FUNCTION funcao(n) !COMO COLOCAR ARGUMENTOS QUE ESTÃO NO MÓDULO?? - isso aqui tá certo?
    
        USE dados_globais !Utilização do módulo definido anteriormente.
        IMPLICIT NONE !precisa disso aqui??
        SAVE !e disso??
        
        !Declaração de argumentos
        DOUBLE PRECISION, INTENT(IN) :: n
                                        !Refere-se à densidade numérica de grãos de poeira.
        
        !Declaração de variáveis internas
        DOUBLE PRECISION :: B1_ef, B2_ef, B1_poeira, B2_poeira, produto, dividendo, divisor, divisao
                            !Respectivamente, a função de corpo negro na banda1 e banda2 para a estrela
                            !(Tef), nas mesmas bandas para a poeira (Tpoeira) e partes da funcao separadas
                            !por fins de clareza e organização do código.
                            
        !Calculando a funcao(n)
        B1_ef = corponegro(banda1, Tef)
        B1_poeira = corponegro(banda1, Tpoeira)
        B2_ef = corponegro(banda2, Tef)
        B2_poeira = corponegro(banda2, Tpoeira)
        
        produto = (4 * pi * a**2 / 3)(Re**3 - Ri**3)

        dividendo = R**2 * B1_ef + produto * B1_poeira * n
        divisor = R**2 * B2_ef + produto * B2_poeira * n

        divisao = dividendo / divisor
        
        funcao = (banda1 - banda2) + 2,5 * log10(divisao)
    
    END FUNCTION funcao




IMPLICIT NONE

!Criando uma função:

FUNCTION nomedafuncao(arg1, arg2, argn)

END FUNCTION nomedafuncao

!Criando uma subrotina

SUBROUTINE nomedasubrotina(arg1, argn)

END SUBROUTINE nomedasubrotina

!Criando um módulo

MODULE nomedomodulo

END MODULE nomedomodulo

!Acessando um módulo

USE nomedomodulo !vem logo depois do FUNCTION/MODULE/whatever, antes mesmo até do implicit none


END PROGRAM envoltorio_poeira
